/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll.annotations.generator;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleNumber;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.appcelerator.kroll.annotations.generator.JSONUtils;
import org.appcelerator.kroll.annotations.generator.KrollAnnotationUtils;
import org.appcelerator.kroll.annotations.generator.KrollVisitor;
import org.json.simple.JSONValue;

@SupportedAnnotationTypes(value={"org.appcelerator.kroll.annotations.Kroll.proxy", "org.appcelerator.kroll.annotations.Kroll.module"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"kroll.jsonPackage", "kroll.jsonFile"})
public class KrollBindingGenerator
extends AbstractProcessor {
    protected static final String TAG = "KrollBindingGen";
    protected static final String Kroll_package = "org.appcelerator.kroll";
    protected static final String Kroll_annotation = "org.appcelerator.kroll.annotations.Kroll";
    protected static final String Kroll_argument = "org.appcelerator.kroll.annotations.Kroll.argument";
    protected static final String Kroll_constant = "org.appcelerator.kroll.annotations.Kroll.constant";
    protected static final String Kroll_getProperty = "org.appcelerator.kroll.annotations.Kroll.getProperty";
    protected static final String Kroll_inject = "org.appcelerator.kroll.annotations.Kroll.inject";
    protected static final String Kroll_inject_DEFAULT = "org.appcelerator.kroll.annotations.Kroll.inject.DEFAULT";
    protected static final String Kroll_method = "org.appcelerator.kroll.annotations.Kroll.method";
    protected static final String Kroll_module = "org.appcelerator.kroll.annotations.Kroll.module";
    protected static final String Kroll_module_DEFAULT = "org.appcelerator.kroll.annotations.Kroll.module.DEFAULT";
    protected static final String Kroll_property = "org.appcelerator.kroll.annotations.Kroll.property";
    protected static final String Kroll_proxy = "org.appcelerator.kroll.annotations.Kroll.proxy";
    protected static final String Kroll_proxy_DEFAULT = "org.appcelerator.kroll.annotations.Kroll.proxy.DEFAULT";
    protected static final String Kroll_setProperty = "org.appcelerator.kroll.annotations.Kroll.setProperty";
    protected static final String Kroll_topLevel = "org.appcelerator.kroll.annotations.Kroll.topLevel";
    protected static final String Kroll_onAppCreate = "org.appcelerator.kroll.annotations.Kroll.onAppCreate";
    protected static final String KrollInvocation = "org.appcelerator.kroll.KrollInvocation";
    protected static final String KrollConverter = "org.appcelerator.kroll.KrollConverter";
    protected static final String KrollModule = "org.appcelerator.kroll.KrollModule";
    protected static final String DEFAULT_NAME = "__default_name__";
    protected static final String Kroll_DEFAULT = "org.appcelerator.kroll.annotations.Kroll.DEFAULT";
    protected static final String PROPERTY_JSON_PACKAGE = "kroll.jsonPackage";
    protected static final String PROPERTY_JSON_FILE = "kroll.jsonFile";
    protected static final String DEFAULT_JSON_PACKAGE = "org.appcelerator.titanium.gen";
    protected static final String DEFAULT_JSON_FILE = "bindings.json";
    protected Template bindingTemplate;
    protected Map<Object, Object> properties = new HashMap<Object, Object>();
    protected Map<Object, Object> proxyProperties = new HashMap<Object, Object>();
    protected Configuration fmConfig = new Configuration();
    protected KrollAnnotationUtils utils;
    protected JSONUtils jsonUtils;
    protected String jsonPackage;
    protected String jsonFile;
    protected boolean initialized = false;

    public KrollBindingGenerator() {
        this.fmConfig.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        try {
            this.bindingTemplate = new Template("ProxyBinding.fm", (Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("org/appcelerator/kroll/annotations/generator/ProxyBinding.fm")), this.fmConfig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        if (!roundEnv.processingOver()) {
            for (Element element : roundEnv.getRootElements()) {
                this.processKrollProxy(element);
            }
        } else {
            this.generateJSON();
            this.generateProxies();
        }
        return true;
    }

    protected void debug(String format, Object ... args) {
        this.utils.debugLog(TAG, String.format(format, args));
    }

    protected void warn(String format, Object ... args) {
        this.utils.debugLog(Diagnostic.Kind.WARNING, TAG, String.format(format, args));
    }

    protected void initialize() {
        this.utils = new KrollAnnotationUtils(this.processingEnv);
        this.jsonUtils = new JSONUtils(this.utils);
        this.debug("Running Kroll binding generator.", new Object[0]);
        String jsonPackage = this.processingEnv.getOptions().get(PROPERTY_JSON_PACKAGE);
        this.jsonPackage = jsonPackage != null ? jsonPackage : DEFAULT_JSON_PACKAGE;
        String jsonFile = this.processingEnv.getOptions().get(PROPERTY_JSON_FILE);
        this.jsonFile = jsonFile != null ? jsonFile : DEFAULT_JSON_FILE;
        try {
            FileObject bindingsFile = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, this.jsonPackage, this.jsonFile);
            String jsonPath = bindingsFile.toUri().toString();
            if (System.getProperty("os.name").contains("Windows")) {
                jsonPath = jsonPath.substring(6);
            }
            this.properties = (Map)JSONValue.parseWithException((Reader)new FileReader(jsonPath));
            this.debug("Succesfully loaded existing binding data.", new Object[0]);
        }
        catch (Exception e) {
            this.debug("No binding data found, creating new data file.", new Object[0]);
        }
    }

    protected void processKrollProxy(final Element element) {
        this.utils.acceptAnnotations(element, new String[]{Kroll_proxy, Kroll_module}, new KrollVisitor<AnnotationMirror>(){

            protected Map<Object, Object> getProxyProperties(String packageName, String proxyClassName) {
                if (KrollBindingGenerator.this.properties == null) {
                    KrollBindingGenerator.this.properties = new HashMap<Object, Object>();
                }
                return KrollBindingGenerator.this.jsonUtils.getOrCreateMap(KrollBindingGenerator.this.jsonUtils.getOrCreateMap(KrollBindingGenerator.this.properties, "proxies"), packageName + "." + proxyClassName);
            }

            protected Map<Object, Object> getModule(String moduleClassName) {
                if (KrollBindingGenerator.this.properties == null) {
                    KrollBindingGenerator.this.properties = new HashMap<Object, Object>();
                }
                return KrollBindingGenerator.this.jsonUtils.getOrCreateMap(KrollBindingGenerator.this.jsonUtils.getOrCreateMap(KrollBindingGenerator.this.properties, "modules"), moduleClassName);
            }

            @Override
            public boolean visit(AnnotationMirror annotation, Object arg) {
                String createInModuleClass;
                String packageName = KrollBindingGenerator.this.utils.getPackage(element);
                String proxyClassName = KrollBindingGenerator.this.utils.getName(element);
                String fullProxyClassName = String.format("%s.%s", packageName, proxyClassName);
                KrollBindingGenerator.this.proxyProperties = this.getProxyProperties(packageName, proxyClassName);
                String genClassName = proxyClassName + "BindingGen";
                String sourceName = String.format("%s.%s", packageName, genClassName);
                String apiName = proxyClassName;
                int proxyIdx = proxyClassName.indexOf("Proxy");
                if (proxyIdx != -1) {
                    apiName = proxyClassName.substring(0, proxyIdx);
                } else {
                    int moduleIdx = proxyClassName.indexOf("Module");
                    if (moduleIdx != -1) {
                        apiName = proxyClassName.substring(0, moduleIdx);
                    }
                }
                HashMap<String, Object> proxyAttrs = KrollBindingGenerator.this.utils.getAnnotationParams(annotation);
                if (proxyAttrs.get("name").equals(KrollBindingGenerator.DEFAULT_NAME)) {
                    proxyAttrs.put("name", apiName);
                } else {
                    apiName = (String)proxyAttrs.get("name");
                }
                if (!proxyAttrs.containsKey("id") || proxyAttrs.get("id").equals(KrollBindingGenerator.DEFAULT_NAME)) {
                    proxyAttrs.put("id", fullProxyClassName);
                }
                KrollBindingGenerator.this.debug("Found binding for %s %s", KrollBindingGenerator.this.utils.annotationTypeIs(annotation, KrollBindingGenerator.Kroll_module) ? "module" : "proxy", apiName);
                proxyAttrs.put("proxyClassName", String.format("%s.%s", packageName, proxyClassName));
                if (proxyAttrs.containsKey("creatableInModule") && !(createInModuleClass = (String)proxyAttrs.get("creatableInModule")).equals(KrollBindingGenerator.Kroll_proxy_DEFAULT)) {
                    KrollBindingGenerator.this.jsonUtils.appendUniqueObject(this.getModule(createInModuleClass), "createProxies", "proxyClassName", proxyAttrs);
                }
                if (proxyAttrs.containsKey("parentModule")) {
                    String parentModuleClass = (String)proxyAttrs.get("parentModule");
                    if (!parentModuleClass.equals(KrollBindingGenerator.Kroll_module_DEFAULT)) {
                        KrollBindingGenerator.this.jsonUtils.appendUniqueObject(this.getModule(parentModuleClass), "childModules", "proxyClassName", proxyAttrs);
                    } else {
                        proxyAttrs.remove("parentModule");
                    }
                }
                boolean isTopLevel = KrollBindingGenerator.this.utils.hasAnnotation(element, KrollBindingGenerator.Kroll_topLevel);
                proxyAttrs.put("isTopLevel", isTopLevel);
                if (isTopLevel) {
                    HashMap<String, Object> topLevelParams = KrollBindingGenerator.this.utils.getAnnotationParams(element, KrollBindingGenerator.Kroll_topLevel);
                    List<String> topLevelNames = (List<String>)topLevelParams.get("value");
                    if (topLevelNames.size() == 1 && topLevelNames.get(0).equals(KrollBindingGenerator.DEFAULT_NAME)) {
                        topLevelNames = Arrays.asList(apiName);
                    }
                    proxyAttrs.put("topLevelNames", topLevelNames);
                }
                TypeElement type = (TypeElement)element;
                Element superType = KrollBindingGenerator.this.processingEnv.getTypeUtils().asElement(type.getSuperclass());
                String superTypeName = KrollBindingGenerator.this.utils.getName(superType);
                if (!superTypeName.equals("Object")) {
                    KrollBindingGenerator.this.proxyProperties.put("superProxyBindingClassName", String.format("%s.%sBindingGen", KrollBindingGenerator.this.utils.getPackage(superType), superTypeName));
                }
                KrollBindingGenerator.this.proxyProperties.put("isModule", KrollBindingGenerator.this.utils.annotationTypeIs(annotation, KrollBindingGenerator.Kroll_module));
                KrollBindingGenerator.this.proxyProperties.put("packageName", packageName);
                KrollBindingGenerator.this.proxyProperties.put("proxyClassName", proxyClassName);
                KrollBindingGenerator.this.proxyProperties.put("genClassName", genClassName);
                KrollBindingGenerator.this.proxyProperties.put("sourceName", sourceName);
                KrollBindingGenerator.this.proxyProperties.put("proxyAttrs", proxyAttrs);
                if (KrollBindingGenerator.this.utils.annotationTypeIs(annotation, KrollBindingGenerator.Kroll_module)) {
                    StringBuilder b = new StringBuilder();
                    b.append(packageName).append(".").append(proxyClassName);
                    Map<Object, Object> module = this.getModule(b.toString());
                    module.put("apiName", apiName);
                }
                BindingVisitor visitor = new BindingVisitor();
                for (Element element2 : element.getEnclosedElements()) {
                    element2.accept(visitor, null);
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveTypeTemplate(Template template, String type, Map<Object, Object> root) {
        Writer writer = null;
        try {
            JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(type, new Element[0]);
            writer = jfo.openWriter();
            template.process(root, writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected String getParentModuleClass(Map<String, Object> proxy) {
        if (this.properties.containsKey("modules")) {
            String moduleClass = null;
            if (proxy.containsKey("creatableInModule")) {
                moduleClass = (String)proxy.get("creatableInModule");
            } else if (proxy.containsKey("parentModule")) {
                moduleClass = (String)proxy.get("parentModule");
            }
            return moduleClass;
        }
        return null;
    }

    protected Map<String, Object> getParentModule(Map<String, Object> proxy) {
        String parentModuleClass = this.getParentModuleClass(proxy);
        if (parentModuleClass != null) {
            Map modules = (Map)this.properties.get("modules");
            return (Map)modules.get(parentModuleClass);
        }
        return null;
    }

    protected String findParentModuleName(Map<String, Object> proxy) {
        String parentModuleClass = this.getParentModuleClass(proxy);
        if (parentModuleClass != null) {
            TypeElement type = this.processingEnv.getElementUtils().getTypeElement(parentModuleClass);
            HashMap<String, Object> moduleParams = this.utils.getAnnotationParams(type, Kroll_module);
            String apiName = parentModuleClass.substring(parentModuleClass.lastIndexOf(".") + 1);
            int moduleIdx = apiName.indexOf("Module");
            if (moduleIdx != -1) {
                apiName = apiName.substring(0, moduleIdx);
            }
            if (moduleParams.containsKey("name") && !moduleParams.get("name").equals(DEFAULT_NAME)) {
                apiName = (String)moduleParams.get("name");
            }
            return apiName;
        }
        return null;
    }

    protected void generateFullAPIName(Map<String, Object> proxy) {
        Map<String, Object> parentProxy;
        Map<String, Object> childProxy = proxy;
        String fullAPIName = (String)proxy.get("name");
        for (int i = 0; i < 10 && (parentProxy = this.getParentModule(childProxy)) != null; ++i) {
            String apiName = (String)parentProxy.get("apiName");
            if (apiName == null) {
                apiName = this.findParentModuleName(childProxy);
            }
            fullAPIName = apiName + "." + fullAPIName;
            childProxy = parentProxy;
        }
        proxy.put("fullAPIName", fullAPIName);
    }

    protected void generateJSON() {
        try {
            Map proxies = (Map)this.properties.get("proxies");
            for (String proxyName : proxies.keySet()) {
                Map proxy = (Map)proxies.get(proxyName);
                this.generateFullAPIName((Map)proxy.get("proxyAttrs"));
            }
            FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, this.jsonPackage, this.jsonFile, new Element[0]);
            Writer writer = file.openWriter();
            writer.write(JSONValue.toJSONString(this.properties));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void generateProxies() {
        Map proxies = (Map)this.properties.get("proxies");
        HashCodeMethod hashCodeMethod = new HashCodeMethod();
        for (String proxyName : proxies.keySet()) {
            Map proxy = (Map)proxies.get(proxyName);
            HashMap<Object, Object> root = new HashMap<Object, Object>(proxy);
            root.put("allModules", this.properties.get("modules"));
            root.put("hashCode", hashCodeMethod);
            this.saveTypeTemplate(this.bindingTemplate, proxy.get("packageName") + "." + proxy.get("genClassName"), root);
        }
    }

    protected class HashCodeMethod
    implements TemplateMethodModel {
        protected HashCodeMethod() {
        }

        public TemplateModel exec(List args) throws TemplateModelException {
            String arg = args.get(0).toString();
            return new SimpleNumber(arg.hashCode());
        }
    }

    protected class BindingVisitor
    extends SimpleElementVisitor6<Object, Object>
    implements KrollVisitor<AnnotationMirror> {
        protected BindingVisitor() {
        }

        @Override
        public String visitExecutable(ExecutableElement e, Object p) {
            KrollBindingGenerator.this.utils.acceptAnnotations((Element)e, new String[]{KrollBindingGenerator.Kroll_method, KrollBindingGenerator.Kroll_getProperty, KrollBindingGenerator.Kroll_setProperty, KrollBindingGenerator.Kroll_inject, KrollBindingGenerator.Kroll_topLevel, KrollBindingGenerator.Kroll_onAppCreate}, (KrollVisitor<AnnotationMirror>)this, (Object)e);
            return null;
        }

        @Override
        public Object visitVariable(VariableElement e, Object p) {
            KrollBindingGenerator.this.utils.acceptAnnotations((Element)e, new String[]{KrollBindingGenerator.Kroll_property, KrollBindingGenerator.Kroll_constant, KrollBindingGenerator.Kroll_inject}, (KrollVisitor<AnnotationMirror>)this, (Object)e);
            return null;
        }

        @Override
        public boolean visit(AnnotationMirror annotation, Object arg) {
            if (arg instanceof ExecutableElement) {
                ExecutableElement element = (ExecutableElement)arg;
                if (KrollBindingGenerator.this.utils.annotationTypeIsOneOf(annotation, new String[]{KrollBindingGenerator.Kroll_getProperty, KrollBindingGenerator.Kroll_setProperty})) {
                    this.visitDynamicProperty(annotation, element);
                } else if (KrollBindingGenerator.this.utils.annotationTypeIs(annotation, KrollBindingGenerator.Kroll_inject)) {
                    this.visitInject(annotation, element, true);
                } else if (KrollBindingGenerator.this.utils.annotationTypeIs(annotation, KrollBindingGenerator.Kroll_topLevel)) {
                    this.visitTopLevel(annotation, element);
                } else if (KrollBindingGenerator.this.utils.annotationTypeIs(annotation, KrollBindingGenerator.Kroll_onAppCreate)) {
                    this.visitOnAppCreate(annotation, element);
                } else {
                    this.visitMethod(annotation, element);
                }
            } else if (arg instanceof VariableElement) {
                VariableElement element = (VariableElement)arg;
                if (KrollBindingGenerator.this.utils.annotationTypeIs(annotation, KrollBindingGenerator.Kroll_inject)) {
                    this.visitInject(annotation, element, false);
                } else {
                    this.visitProperty(annotation, element);
                }
            }
            return true;
        }

        protected void visitMethod(AnnotationMirror annotation, ExecutableElement element) {
            String methodName = element.getSimpleName().toString();
            Map<Object, Object> methods = KrollBindingGenerator.this.jsonUtils.getOrCreateMap(KrollBindingGenerator.this.proxyProperties, "methods");
            Map<Object, Object> methodAttrs = KrollBindingGenerator.this.jsonUtils.getOrCreateMap(methods, methodName);
            ArrayList<HashMap<Object, Object>> args = new ArrayList<HashMap<Object, Object>>();
            KrollBindingGenerator.this.jsonUtils.updateObjectFromAnnotation(methodAttrs, annotation);
            methodAttrs.put("hasInvocation", false);
            for (VariableElement variableElement : element.getParameters()) {
                String paramType = KrollBindingGenerator.this.utils.getType(variableElement);
                if (paramType.equals(KrollBindingGenerator.KrollInvocation)) {
                    methodAttrs.put("hasInvocation", true);
                    continue;
                }
                String paramName = KrollBindingGenerator.this.utils.getName(variableElement);
                HashMap<Object, Object> argParams = new HashMap<Object, Object>();
                argParams.put("sourceName", paramName);
                argParams.put("type", paramType);
                KrollBindingGenerator.this.jsonUtils.updateObjectFromAnnotationParams(argParams, KrollBindingGenerator.this.utils.getAnnotationParams(variableElement, KrollBindingGenerator.Kroll_argument));
                String name = (String)argParams.get("name");
                if (name == null || name.equals(KrollBindingGenerator.DEFAULT_NAME)) {
                    argParams.put("name", paramName);
                }
                if (!argParams.containsKey("converter")) {
                    argParams.put("converter", KrollBindingGenerator.KrollConverter);
                }
                if (!argParams.containsKey("defaultValueProvider")) {
                    argParams.put("defaultValueProvider", KrollBindingGenerator.KrollConverter);
                }
                args.add(argParams);
            }
            methodAttrs.put("apiName", methodAttrs.get("name"));
            if (methodAttrs.get("name").equals(KrollBindingGenerator.DEFAULT_NAME)) {
                methodAttrs.put("apiName", methodName);
            }
            methodAttrs.put("args", args);
            methodAttrs.put("returnType", ((Object)element.getReturnType()).toString());
        }

        protected void visitProperty(AnnotationMirror annotation, VariableElement element) {
            boolean isConstant = KrollBindingGenerator.this.utils.annotationTypeIs(annotation, KrollBindingGenerator.Kroll_constant);
            Map<Object, Object> propertyMap = KrollBindingGenerator.this.jsonUtils.getOrCreateMap(KrollBindingGenerator.this.proxyProperties, isConstant ? "constants" : "properties");
            HashMap<String, Object> property = KrollBindingGenerator.this.utils.getAnnotationParams(annotation);
            String type = KrollBindingGenerator.this.utils.getType(element);
            property.put("type", type);
            String defaultName = KrollBindingGenerator.this.utils.getName(element);
            property.put("proxyName", defaultName);
            String name = (String)property.get("name");
            if (name.equals(KrollBindingGenerator.DEFAULT_NAME)) {
                property.put("name", defaultName);
                name = defaultName;
            }
            propertyMap.put(name, property);
        }

        protected void visitDynamicProperty(AnnotationMirror annotation, ExecutableElement element) {
            Map<Object, Object> dynamicProperties = KrollBindingGenerator.this.jsonUtils.getOrCreateMap(KrollBindingGenerator.this.proxyProperties, "dynamicProperties");
            HashMap<String, Object> params = KrollBindingGenerator.this.utils.getAnnotationParams(annotation);
            Map<String, Object> dynamicProperty = new HashMap<String, Object>(params);
            String methodName = KrollBindingGenerator.this.utils.getName(element);
            String defaultName = new String(methodName);
            if (defaultName.startsWith("get") || defaultName.startsWith("set")) {
                defaultName = Character.toLowerCase(defaultName.charAt(3)) + defaultName.substring(4);
            } else if (defaultName.startsWith("is")) {
                defaultName = Character.toLowerCase(defaultName.charAt(2)) + defaultName.substring(3);
            }
            String name = (String)dynamicProperty.get("name");
            if (name.equals(KrollBindingGenerator.DEFAULT_NAME)) {
                dynamicProperty.put("name", defaultName);
                name = defaultName;
            }
            if (dynamicProperties.containsKey(name)) {
                dynamicProperty = (Map)dynamicProperties.get(name);
            } else {
                dynamicProperty.put("get", false);
                dynamicProperty.put("set", false);
                dynamicProperty.put("nativeConverter", KrollBindingGenerator.KrollConverter);
                dynamicProperty.put("javascriptConverter", KrollBindingGenerator.KrollConverter);
                dynamicProperty.put("getHasInvocation", false);
                dynamicProperty.put("setHasInvocation", false);
            }
            ArrayList<HashMap<Object, Object>> args = new ArrayList<HashMap<Object, Object>>();
            for (VariableElement variableElement : element.getParameters()) {
                String string = KrollBindingGenerator.this.utils.getType(variableElement);
                if (string.equals(KrollBindingGenerator.KrollInvocation)) {
                    if (KrollBindingGenerator.this.utils.annotationTypeIs(annotation, KrollBindingGenerator.Kroll_getProperty)) {
                        dynamicProperty.put("getHasInvocation", true);
                        continue;
                    }
                    dynamicProperty.put("setHasInvocation", true);
                    continue;
                }
                String paramName = KrollBindingGenerator.this.utils.getName(variableElement);
                HashMap<Object, Object> argParams = new HashMap<Object, Object>();
                argParams.put("sourceName", paramName);
                argParams.put("type", string);
                KrollBindingGenerator.this.jsonUtils.updateObjectFromAnnotationParams(argParams, KrollBindingGenerator.this.utils.getAnnotationParams(variableElement, KrollBindingGenerator.Kroll_argument));
                String argName = (String)argParams.get("name");
                if (argName == null || argName.equals(KrollBindingGenerator.DEFAULT_NAME)) {
                    argParams.put("name", paramName);
                }
                if (!argParams.containsKey("converter")) {
                    argParams.put("converter", KrollBindingGenerator.KrollConverter);
                }
                if (!argParams.containsKey("defaultValueProvider")) {
                    argParams.put("defaultValueProvider", KrollBindingGenerator.KrollConverter);
                }
                args.add(argParams);
            }
            ArrayList<String> defaultProviders = new ArrayList<String>();
            for (VariableElement variableElement : element.getParameters()) {
                if (KrollBindingGenerator.this.utils.hasAnnotation(variableElement, KrollBindingGenerator.Kroll_argument)) {
                    defaultProviders.add((String)KrollBindingGenerator.this.utils.getAnnotationParams(variableElement, KrollBindingGenerator.Kroll_argument).get("defaultValueProvider"));
                    continue;
                }
                defaultProviders.add(KrollBindingGenerator.KrollConverter);
            }
            if (KrollBindingGenerator.this.utils.annotationTypeIs(annotation, KrollBindingGenerator.Kroll_getProperty)) {
                dynamicProperty.put("get", true);
                dynamicProperty.put("getMethodName", methodName);
                dynamicProperty.put("getDefaultProviders", defaultProviders);
                dynamicProperty.put("getMethodArgs", args);
                dynamicProperty.put("getReturnType", ((Object)element.getReturnType()).toString());
            } else {
                dynamicProperty.put("set", true);
                dynamicProperty.put("setMethodName", methodName);
                dynamicProperty.put("setDefaultProviders", defaultProviders);
                dynamicProperty.put("retain", params.get("retain"));
                dynamicProperty.put("setMethodArgs", args);
                dynamicProperty.put("setReturnType", ((Object)element.getReturnType()).toString());
            }
            dynamicProperties.put(name, dynamicProperty);
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void visitInject(AnnotationMirror annotation, Element element, boolean isMethod) {
            String name;
            List<Object> injectList = KrollBindingGenerator.this.jsonUtils.getOrCreateList(KrollBindingGenerator.this.proxyProperties, isMethod ? "injectMethods" : "injectFields");
            HashMap<String, Object> attrs = KrollBindingGenerator.this.utils.getAnnotationParams(annotation);
            String type = (String)attrs.get("type");
            String defaultType = null;
            if (isMethod) {
                List<? extends VariableElement> params = ((ExecutableElement)element).getParameters();
                if (params.size() <= 0) {
                    KrollBindingGenerator.this.warn("Skipping injection into method %s, at least one argument is required in a setter", KrollBindingGenerator.this.utils.getName(element));
                    return;
                }
                VariableElement firstParam = params.get(0);
                defaultType = KrollBindingGenerator.this.utils.getType(firstParam);
            } else {
                defaultType = KrollBindingGenerator.this.utils.getType((VariableElement)element);
            }
            if (type.equals(KrollBindingGenerator.Kroll_DEFAULT)) {
                attrs.put("type", defaultType);
            }
            if ((name = (String)attrs.get("name")).equals(KrollBindingGenerator.DEFAULT_NAME)) {
                attrs.put("name", KrollBindingGenerator.this.utils.getName(element));
            }
            injectList.add(attrs);
        }

        protected void visitTopLevel(AnnotationMirror annotation, Element element) {
            Map<Object, Object> topLevelMethods = KrollBindingGenerator.this.jsonUtils.getOrCreateMap(KrollBindingGenerator.this.proxyProperties, "topLevelMethods");
            HashMap<String, Object> attrs = KrollBindingGenerator.this.utils.getAnnotationParams(annotation);
            List<Object> topLevelNames = (List<Object>)attrs.get("value");
            if (topLevelNames.size() == 1 && topLevelNames.get(0).equals(KrollBindingGenerator.DEFAULT_NAME)) {
                topLevelNames = Arrays.asList(KrollBindingGenerator.this.utils.getName(element));
            }
            topLevelMethods.put(KrollBindingGenerator.this.utils.getName(element), topLevelNames);
        }

        protected void visitOnAppCreate(AnnotationMirror annotation, Element element) {
            KrollBindingGenerator.this.proxyProperties.put("onAppCreate", KrollBindingGenerator.this.utils.getName(element));
        }
    }
}

