/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll.annotations.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import org.appcelerator.kroll.annotations.generator.KrollVisitor;

public class KrollAnnotationUtils {
    protected ProcessingEnvironment env;

    public KrollAnnotationUtils(ProcessingEnvironment env) {
        this.env = env;
    }

    public boolean annotationTypeIs(AnnotationMirror annotation, String annotationClass) {
        String annotationType = annotation.getAnnotationType().toString();
        String annotationClassName = annotationClass.replace("$", ".");
        return annotationType.equals(annotationClassName);
    }

    public boolean annotationTypeIsOneOf(AnnotationMirror annotation, String[] annotationClasses) {
        boolean found = false;
        for (String annClass : annotationClasses) {
            if (!this.annotationTypeIs(annotation, annClass)) continue;
            found = true;
            break;
        }
        return found;
    }

    public void debugLog(String message) {
        this.debugLog(Diagnostic.Kind.NOTE, message);
    }

    public void debugLog(String category, String message) {
        this.debugLog(Diagnostic.Kind.NOTE, category, message);
    }

    public void debugLog(Diagnostic.Kind debugType, String category, String message) {
        this.debugLog(debugType, "[" + category + "] " + message);
    }

    public void debugLog(Diagnostic.Kind debugType, String message) {
        Messager msg = this.env.getMessager();
        msg.printMessage(Diagnostic.Kind.NOTE, message);
    }

    public void logException(Exception exception) {
        this.debugLog(Diagnostic.Kind.ERROR, exception.getMessage());
        exception.printStackTrace();
    }

    public Object convertAnnotationValue(Object value) {
        if (value instanceof DeclaredType) {
            return ((Object)((DeclaredType)value).asElement().asType()).toString();
        }
        if (value instanceof List) {
            ArrayList<Object> newList = new ArrayList<Object>();
            List list = (List)value;
            ListIterator iter = list.listIterator();
            while (iter.hasNext()) {
                AnnotationValue item = (AnnotationValue)iter.next();
                newList.add(this.convertAnnotationValue(item.getValue()));
            }
            return newList;
        }
        return value;
    }

    public HashMap<String, Object> mapToHash(Map<? extends ExecutableElement, ? extends AnnotationValue> source) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> mirrorEntry : source.entrySet()) {
            String mirrorKey = mirrorEntry.getKey().getSimpleName().toString();
            Object value = mirrorEntry.getValue().getValue();
            result.put(mirrorKey, this.convertAnnotationValue(value));
        }
        return result;
    }

    public HashMap<String, Object> getAnnotationParams(AnnotationMirror annotation) {
        return this.mapToHash(this.env.getElementUtils().getElementValuesWithDefaults(annotation));
    }

    public String getName(Element el) {
        return el.getSimpleName().toString();
    }

    public String getPackage(Element el) {
        return this.env.getElementUtils().getPackageOf(el).getQualifiedName().toString();
    }

    public String getType(VariableElement el) {
        return ((Object)el.asType()).toString();
    }

    public String getType(DeclaredType type) {
        return this.getName(type.asElement());
    }

    public String getReturnType(ExecutableElement el) {
        return ((Object)el.getReturnType()).toString();
    }

    public boolean typeIs(String type, Class<?> clazz) {
        return type.equals(clazz.getName());
    }

    public boolean typeIs(VariableElement el, Class<?> clazz) {
        return this.typeIs(this.getType(el), clazz);
    }

    public HashMap<String, Object> getAnnotationParams(Element element, String annotationClass) {
        final HashMap<String, Object> params = new HashMap<String, Object>();
        this.acceptAnnotations(element, annotationClass, new KrollVisitor<AnnotationMirror>(){

            @Override
            public boolean visit(AnnotationMirror element, Object arg) {
                params.putAll(KrollAnnotationUtils.this.getAnnotationParams(element));
                return true;
            }
        });
        return params;
    }

    public boolean acceptAnnotations(Element element, String annotationClass, KrollVisitor<AnnotationMirror> visitor) {
        return this.acceptAnnotations(element, new String[]{annotationClass}, visitor, null);
    }

    public boolean acceptAnnotations(Element element, String annotationClass, KrollVisitor<AnnotationMirror> visitor, Object arg) {
        return this.acceptAnnotations(element, new String[]{annotationClass}, visitor, arg);
    }

    public boolean acceptAnnotations(Element element, String[] annotationClasses, KrollVisitor<AnnotationMirror> visitor) {
        return this.acceptAnnotations(element, annotationClasses, visitor, null);
    }

    public boolean acceptAnnotations(Element element, String[] annotationClasses, KrollVisitor<AnnotationMirror> visitor, Object arg) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.annotationTypeIsOneOf(annotationMirror, annotationClasses) || visitor.visit(annotationMirror, arg)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAnnotation(Element element, String annotationClass) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.annotationTypeIs(annotationMirror, annotationClass)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyAnnotation(Element element, String ... annotationClasses) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.annotationTypeIsOneOf(annotationMirror, annotationClasses)) continue;
            return true;
        }
        return false;
    }
}

