/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll.annotations.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import org.appcelerator.kroll.annotations.generator.KrollAnnotationUtils;

public class JSONUtils {
    protected KrollAnnotationUtils annUtils;

    public JSONUtils(KrollAnnotationUtils annUtils) {
        this.annUtils = annUtils;
    }

    public Map<Object, Object> getOrCreateMap(Map<Object, Object> map, String name) {
        HashMap subMap = (HashMap)map.get(name);
        if (subMap == null) {
            subMap = new HashMap();
            map.put(name, subMap);
        }
        return subMap;
    }

    public List<Object> getOrCreateList(Map<Object, Object> map, String name) {
        ArrayList list = (ArrayList)map.get(name);
        if (list == null) {
            list = new ArrayList();
            map.put(name, list);
        }
        return list;
    }

    public void appendUnique(Map<Object, Object> parent, String arrayName, Object value) {
        this.appendUnique(this.getOrCreateList(parent, arrayName), value);
    }

    public void appendUnique(List<Object> list, Object value) {
        boolean found = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(value)) continue;
            found = true;
            break;
        }
        if (!found) {
            list.add(value);
        }
    }

    public void appendUniqueObject(Map<Object, Object> parent, String arrayName, Object key, Map<? extends Object, Object> value) {
        this.appendUniqueObject(this.getOrCreateList(parent, arrayName), key, value);
    }

    public void appendUniqueObject(List<Object> list, Object key, Map<? extends Object, Object> value) {
        boolean found = false;
        for (int i = 0; i < list.size(); ++i) {
            Map map;
            Object mapValue;
            Object v = list.get(i);
            if (!(v instanceof Map) || (mapValue = (map = (Map)v).get(key)) == null || !value.get(key).equals(mapValue)) continue;
            found = true;
            break;
        }
        if (!found) {
            list.add(value);
        }
    }

    public void updateObjectFromAnnotation(Map<Object, Object> object, AnnotationMirror annotation) {
        this.updateObjectFromAnnotationParams(object, this.annUtils.getAnnotationParams(annotation));
    }

    public void updateObjectFromAnnotationParams(Map<Object, Object> object, HashMap<String, Object> params) {
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (object.containsKey(key)) {
                Object currentValue = object.get(key);
                if (currentValue instanceof List && value instanceof List) {
                    List currentList = (List)currentValue;
                    for (int i = 0; i < currentList.size(); ++i) {
                        this.appendUnique(currentList, ((List)value).get(i));
                    }
                    continue;
                }
                if (value instanceof Class) {
                    object.put(key, ((Class)value).getName());
                    continue;
                }
                object.put(key, value);
                continue;
            }
            object.put(key, value);
        }
    }
}

