#ifndef _CPGLOCK_INT_H
#define _CPGLOCK_INT_H

#ifndef CPG_LOCKD_SOCK
#define CPG_LOCKD_SOCK "/var/run/cpglockd.sk"
#endif

#include <stdint.h>

typedef enum {
	MSG_LOCK   = 1,
	MSG_NAK    = 2,
	MSG_GRANT  = 3,
	MSG_UNLOCK = 4,
	MSG_PURGE  = 5,
	MSG_CONFCHG= 6,
	MSG_JOIN   = 7,
	MSG_DUMP   = 998,
	MSG_HALT   = 999
} cpg_lock_req_t;

struct cpg_lock_msg {
	int32_t request;
	uint32_t owner_nodeid;
	uint32_t owner_pid;
	uint32_t flags;
	uint32_t lockid;
	uint32_t owner_tid;
	char resource[96];
	char pad[8];
} __attribute__((packed)); /* 128 */

#define CPG_LOCKD_NAME "cpglockd"

#endif
